﻿using VRM.Integration.FTP.MVI.Messages;
using IMessageBase = VRM.Integration.Servicebus.Core.IMessageBase;
using Logger = VRM.Integration.Servicebus.Core.Logger;
using VRM.Integration.Servicebus.Core;
using MVIMessages = VRM.Integration.Mvi.PersonSearch.Messages;
using VRM.Integration.Mvi.PersonSearch;
using System;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VRM.Integration.FTP.MVI.MVIPersonSearch;

namespace VRM.Integration.FTP.MVI.Processors
{

    public class FTPSelectedPersonProcessor
    {
        public IMessageBase Execute(FTPSelectedPersonRequest request)
        {
            FTPCorrespondingIdsResponse response = new FTPCorrespondingIdsResponse();

            try
            {

                if (request == null)
                {
                    Logger.Instance.Warn(string.Format("{0} recieved a null message", GetType().FullName));
                    response.ExceptionOccured = true;
                    response.RawMviExceptionMessage = string.Format("{0} recieved a null message", GetType().FullName);
                }
                else
                {
                    Logger.Instance.Info(string.Format("Message Id:{0}, Type={2}, Recieved diagnostics message: {1}",
                        request.MessageId,
                        request.MessageId,
                        GetType().FullName));

                    var personSearch = new PersonSearch();
                    response = personSearch.GetCorrespondingIDs(request);
                    Logger.Instance.Info(string.Format("MicroService PersonSearch.GetCorrespondingIDs Test Result - MessageID: {0}", response.MessageId));

                }

                return response;
            }
            catch (Exception ex)
            {
                LogHelper.LogError(request.OrganizationName, null, request.UserId, "FTPSelectedPersonProcessor, Execute", "Exception:" + ex.Message);
                response.ExceptionOccured = true;
                response.Message = ex.Message;
                return response;
            }
        }

    }
}
